<?php if($categoriesSection && $homeCategories->count() > 0): ?>
    <section class="section section-start">
        <div class="container container-custom">
            <div class="section-header">
                <div class="row row-cols-auto align-items-center justify-content-center justify-content-lg-between g-3">
                    <div class="col">
                        <div class="section-title mb-0">
                            <h2 class="section-title-text"><?php echo e($categoriesSection->name); ?></h2>
                            <div class="section-title-divider"></div>
                        </div>
                        <?php if($categoriesSection->description): ?>
                            <p class="section-text mt-3"><?php echo e($categoriesSection->description); ?></p>
                        <?php endif; ?>
                    </div>
                    <div class="col d-none d-lg-block">
                        <a href="<?php echo e(route('categories.index')); ?>">
                            <?php echo e(translate('View All')); ?>

                            <i class="fa fa-chevron-right fa-sm fa-rtl ms-2"></i>
                        </a>
                    </div>
                </div>
            </div>
            <div class="section-body">
                <div class="categories-swiper mt-3">
                    <div class="swiper-actions">
                        <div id="categoriesSwiperPrev" class="swiper-button-prev">
                            <i class="fa fa-chevron-left fa-rtl"></i>
                        </div>
                    </div>
                    <div class="swiper categoriesSwiper">
                        <div class="swiper-wrapper">
                            <?php $__currentLoopData = $homeCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $homeCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="swiper-slide">
                                    <a href="<?php echo e($homeCategory->link); ?>" class="category">
                                        <div class="category-img">
                                            <img src="<?php echo e($homeCategory->getIcon()); ?>" alt="<?php echo e($homeCategory->name); ?>" />
                                        </div>
                                        <h6 class="category-title"><?php echo e($homeCategory->name); ?></h6>
                                    </a>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <div class="swiper-actions">
                        <div id="categoriesSwiperNext" class="swiper-button-next">
                            <i class="fa fa-chevron-right fa-rtl"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>
<?php /**PATH /home/novaspi1/public_html/resources/views/themes/basic/sections/categories.blade.php ENDPATH**/ ?>