<?php if($featuredItemsSection && $featuredItems->count() > 0): ?>
    <div class="section section-start">
        <div class="container container-custom">
            <div class="section-header d-block d-xxl-none">
                <div class="row row-cols-auto align-items-center justify-content-center justify-content-lg-between g-3">
                    <div class="col">
                        <div class="section-title mb-0">
                            <h2 class="section-title-text"><?php echo e($featuredItemsSection->name); ?></h2>
                            <div class="section-title-divider"></div>
                        </div>
                        <?php if($featuredItemsSection->description): ?>
                            <p class="section-text mt-3"><?php echo e($featuredItemsSection->description); ?></p>
                        <?php endif; ?>
                    </div>
                    <div class="col d-none d-lg-block">
                        <a href="<?php echo e(route('items.index', ['featured' => 'true'])); ?>">
                            <?php echo e(translate('View All')); ?>

                            <i class="fa fa-chevron-right fa-sm fa-rtl ms-2"></i>
                        </a>
                    </div>
                </div>
            </div>
            <div class="section-body">
                <div class="row g-3">
                    <div class="col-xxl-4 d-none d-xxl-block">
                        <div class="card-v border border-primary border-dashed h-100 p-3" data-aos="fade-up"
                            data-aos-duration="1000">
                            <div class="card-v card-bg d-flex justify-content-center align-items-center h-100">
                                <div class="p-3">
                                    <h2 class="mb-2"><?php echo e($featuredItemsSection->name); ?></h2>
                                    <?php if($featuredItemsSection->description): ?>
                                        <p class="fw-light mb-3"><?php echo e($featuredItemsSection->description); ?></p>
                                    <?php endif; ?>
                                    <a href="<?php echo e(route('items.index', ['featured' => 'true'])); ?>"
                                        class="btn btn-primary btn-md w-100">
                                        <?php echo e(translate('View All Featured Items')); ?>

                                        <i class="fa fa-arrow-right fa-rtl ms-2"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-xxl-8">
                        <div class="row row-cols-md-2 row-cols-lg-3 row-cols-xxl-2 g-4">
                            <?php $__currentLoopData = $featuredItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $featuredItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col" data-aos="fade-up" data-aos-duration="1500">
                                    <?php echo $__env->make('themes.basic.partials.item', ['item' => $featuredItem], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
                <div class="text-center mt-5 d-block d-lg-none">
                    <a href="<?php echo e(route('items.index', ['featured' => 'true'])); ?>">
                        <?php echo e(translate('View All')); ?>

                        <i class="fa fa-chevron-right fa-sm fa-rtl ms-2"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH /home/novaspi1/public_html/resources/views/themes/basic/sections/featured-items.blade.php ENDPATH**/ ?>