<div class="drop-down user-menu <?php echo e($menu_class ?? ''); ?>" data-dropdown data-dropdown-position="top">
    <div class="drop-down-btn">
        <img src="<?php echo e(authUser()->getAvatar()); ?>" alt="<?php echo e(authUser()->getName()); ?>" class="user-img">
        <span class="user-name"><?php echo e(authUser()->getName()); ?></span>
        <i class="fa fa-angle-down ms-2"></i>
    </div>
    <div class="drop-down-menu">
        <?php if(authUser()->isDataCompleted()): ?>
            <a href="<?php echo e(authUser()->getProfileLink()); ?>" class="drop-down-item">
                <i class="fa-solid fa-user"></i>
                <?php echo e(translate('Profile')); ?>

            </a>
            <?php if(authUser()->isAuthor()): ?>
                <a href="<?php echo e(route('workspace.dashboard')); ?>" class="drop-down-item">
                    <i class="fa-solid fa-table-columns"></i>
                    <?php echo e(translate('Dashboard')); ?>

                </a>
            <?php endif; ?>
            <a href="<?php echo e(route('favorites')); ?>" class="drop-down-item">
                <i class="fa-solid fa-heart"></i>
                <?php echo e(translate('Favorites')); ?>

            </a>
            <a href="<?php echo e(route('workspace.purchases.index')); ?>" class="drop-down-item">
                <i class="fa-solid fa-basket-shopping"></i>
                <?php echo e(translate('Purchases')); ?>

            </a>
            <a href="<?php echo e(route('workspace.transactions.index')); ?>" class="drop-down-item">
                <i class="fa-solid fa-receipt"></i>
                <?php echo e(translate('Transactions')); ?>

            </a>
            <a href="<?php echo e(route('workspace.statements')); ?>" class="drop-down-item">
                <i class="fa-solid fa-file-lines"></i>
                <?php echo e(translate('Statements')); ?>

            </a>
            <a href="<?php echo e(route('workspace.settings.index')); ?>" class="drop-down-item">
                <i class="fa fa-cog"></i>
                <?php echo e(translate('Settings')); ?>

            </a>
            <div class="drop-down-divider"></div>
            <?php if(authUser()->isAuthor()): ?>
                <a href="<?php echo e(route('workspace.items.index')); ?>" class="drop-down-item">
                    <i class="fa-solid fa-box-open"></i>
                    <?php echo e(translate('My Items')); ?>

                </a>
                <a href="<?php echo e(route('workspace.referrals')); ?>" class="drop-down-item">
                    <i class="fa-solid fa-user-group"></i>
                    <?php echo e(translate('Referrals')); ?>

                </a>
                <a href="<?php echo e(route('workspace.withdrawals.index')); ?>" class="drop-down-item">
                    <i class="fa-solid fa-paper-plane"></i>
                    <?php echo e(translate('Withdrawals')); ?>

                </a>
            <?php else: ?>
                <a href="<?php echo e(route('workspace.become-an-author')); ?>" class="drop-down-item">
                    <i class="fa-solid fa-box-open"></i>
                    <?php echo e(translate('Start Selling')); ?>

                </a>
            <?php endif; ?>
            <div class="drop-down-divider"></div>
        <?php endif; ?>
        <a href="#" class="drop-down-item text-danger"
            onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
            <i class="fa fa-power-off"></i>
            <?php echo e(translate('Logout')); ?>

        </a>
    </div>
    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST"><?php echo csrf_field(); ?></form>
</div>
<?php /**PATH /home/novaspi1/public_html/resources/views/themes/basic/partials/user-menu.blade.php ENDPATH**/ ?>