<?php if($featuredAuthorSection && $featuredAuthor): ?>
    <div class="section section-start">
        <div class="container container-custom">
            <div class="section-body">
                <div class="border border-dashed border-primary rounded-3 p-3" data-aos="fade-up" data-aos-duration="1000">
                    <div class="card-v">
                        <h1><?php echo e($featuredAuthorSection->name); ?></h1>
                        <?php if($featuredAuthorSection->description): ?>
                            <p class="text-muted"><?php echo e($featuredAuthorSection->description); ?></p>
                        <?php endif; ?>
                        <div class="my-5" data-aos="fade-left" data-aos-duration="1000">
                            <div
                                class="row row-cols-1 row-cols-md-auto text-center text-md-start align-items-center g-2">
                                <div class="col">
                                    <div class="user-avatar user-avatar-xl me-1">
                                        <a href="<?php echo e($featuredAuthor->getProfileLink()); ?>">
                                            <img src="<?php echo e($featuredAuthor->getAvatar()); ?>"
                                                alt="<?php echo e($featuredAuthor->username); ?>">
                                        </a>
                                    </div>
                                </div>
                                <div class="col">
                                    <div class="d-block text-dark fs-5 mb-1">
                                        <a href="<?php echo e($featuredAuthor->getProfileLink()); ?>" class="text-dark">
                                            <h6 class="mb-0 small">
                                                <?php echo e($featuredAuthor->username); ?>

                                            </h6>
                                        </a>
                                    </div>
                                    <p class="mb-0 fs-6 mb-2">
                                        <span class="text-muted small">
                                            <?php echo e(translate('Member since :date', ['date' => dateFormat($featuredAuthor->created_at, 'M Y')])); ?>

                                        </span>
                                    </p>
                                    <div class="row row-cols-auto justify-content-center justify-content-md-start g-2">
                                        <?php if($featuredAuthor->isAuthor()): ?>
                                            <div class="col">
                                                <a href="<?php echo e($featuredAuthor->getPortfolioLink()); ?>"
                                                    class="btn btn-primary">
                                                    <span><?php echo e(translate('View Portfolio')); ?></span>
                                                </a>
                                            </div>
                                        <?php endif; ?>
                                        <div class="col">
                                            <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('follow-button', ['user' => $featuredAuthor])->html();
} elseif ($_instance->childHasBeenRendered('Xk0JkLG')) {
    $componentId = $_instance->getRenderedChildComponentId('Xk0JkLG');
    $componentTag = $_instance->getRenderedChildComponentTagName('Xk0JkLG');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('Xk0JkLG');
} else {
    $response = \Livewire\Livewire::mount('follow-button', ['user' => $featuredAuthor]);
    $html = $response->html();
    $_instance->logRenderedChild('Xk0JkLG', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php if($featuredAuthor->items->count() > 0): ?>
                            <div class="row row-cols-md-2 row-cols-lg-3 row-cols-xxl-3 g-4">
                                <?php $__currentLoopData = $featuredAuthor->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $featuredAuthorItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col" data-aos="fade-up" data-aos-duration="1000">
                                        <?php echo $__env->make('themes.basic.partials.item', [
                                            'item' => $featuredAuthorItem,
                                            'item_classes' => 'border',
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH /home/novaspi1/public_html/resources/views/themes/basic/sections/featured-author.blade.php ENDPATH**/ ?>