<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('refund_replies', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('refund_id')->unsigned();
            $table->bigInteger('user_id')->unsigned();
            $table->longText('body');
            $table->foreign("user_id")->references("id")->on('users')->onDelete('cascade');
            $table->foreign("refund_id")->references("id")->on('refunds')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('refund_replies');
    }
};
